Script.Load( "Data\\Script\\MapTools\\Main.lua" )

IncludeLocals("army_tools")
IncludeLocals("army_bandit")
IncludeLocals("army_defenders")
IncludeLocals("quest_towers")
IncludeLocals("quest_gate")
IncludeLocals("quest_smallGate")
IncludeLocals("quest_defeat")
IncludeLocals("quest_enemyOutpost")
IncludeLocals("quest_bombs")
IncludeLocals("quest_stoneBandits")
IncludeLocals("quest_erec")
IncludeLocals("briefing_inventor")
IncludeLocals("briefing_tip")
IncludeLocals("briefing_prelude")
IncludeLocals("briefing_scout")
IncludeLocals("briefing_bandits")
IncludeLocals("briefing_smallGateOpens")
IncludeLocals("gameControl")
IncludeLocals("player2")
IncludeLocals("player6")

IncludeLocals("TradeBalancer")

IncludeLocals("GetRandom")
IncludeLocals("GetCirclePosition")
IncludeLocals("GetAngleBetween")
IncludeLocals("CopyTable")
IncludeLocals("EntityIDChangedHelper")
IncludeLocals("GetDistance")
IncludeLocals("IsEntityOfType")
IncludeLocals("IsValidPosition")
IncludeLocals("LuaObject")
IncludeLocals("TargetFilter")
IncludeLocals("TriggerFix")
IncludeLocals("UnlimitedArmy")
IncludeLocals("UnlimitedArmySpawnGenerator")
IncludeLocals("Towerlimit")

Cutscenes = {}
Cutscenes[INTROCUTSCENE] = "INTRO"
Cutscenes[THRESHOLDONECUTSCENE] = "SERF"
Cutscenes[MISSIONCOMPLETECUTSCENE] = "MISSIONCOMPLETE"

IncludeLocals("Cutscene_" .. Cutscenes[INTROCUTSCENE])
IncludeLocals("Cutscene_" .. Cutscenes[THRESHOLDONECUTSCENE])
IncludeLocals("Cutscene_" .. Cutscenes[MISSIONCOMPLETECUTSCENE])


--Cheat for GoldChest described in Manual. Only before the map is saved and loaded the first time
--Input.KeyBindDown(Keys.ModifierControl + Keys.ModifierAlt + Keys.G, 		"SpecialManualGoldChest()",2)
SpecialManualGoldChestFound = false

------------------------------------------------------------------------------
function InitDiplomacy()
    SetHostile(1,2)
    SetNeutral(1,4)
    SetNeutral(2,4)
    SetHostile(1,5)
    SetNeutral(1,6)

	end
------------------------------------------------------------------------------
function InitResources()
    -- set some resources
    AddStone(500)
    AddClay(800)
    AddGold(1000)
    AddSulfur(150)
    AddIron(0)
    AddWood(700)
    end
------------------------------------------------------------------------------
function InitTechnologies()
	ForbidTechnology(Technologies.GT_Matchlock)
	ForbidTechnology(Technologies.GT_PulledBarrel)
	Logic.SetTechnologyState(1, Technologies.T_MarketIron, 0)
	
	Logic.SetTechnologyState(2, Technologies.T_LeatherMailArmor, 3)
	Logic.SetTechnologyState(2, Technologies.T_ChainMailArmor, 3)
	Logic.SetTechnologyState(2, Technologies.T_SoftArcherArmor, 3)
	Logic.SetTechnologyState(2, Technologies.T_PaddedArcherArmor, 3)
	Logic.SetTechnologyState(2, Technologies.T_MasterOfSmithery, 3)
	Logic.SetTechnologyState(2, Technologies.T_Fletching, 3)
	Logic.SetTechnologyState(2, Technologies.T_WoodAging, 3)
	Logic.SetTechnologyState(2, Technologies.T_EnhancedGunPowder, 3)
	Logic.SetTechnologyState(2, Technologies.T_BlisteringCannonballs, 3)
	Logic.SetTechnologyState(2, Technologies.T_BetterTrainingBarracks, 3)
	Logic.SetTechnologyState(2, Technologies.T_BetterTrainingArchery, 3)
	Logic.SetTechnologyState(2, Technologies.T_Shoeing, 3)
	Logic.SetTechnologyState(2, Technologies.T_Masonry, 3)
	Logic.SetTechnologyState(2, Technologies.T_FleeceArmor, 3)
	Logic.SetTechnologyState(2, Technologies.T_FleeceLinedLeatherArmor, 3)
	Logic.SetTechnologyState(2, Technologies.T_LeadShot, 3)
	Logic.SetTechnologyState(2, Technologies.T_Sights, 3)
    end
------------------------------------------------------------------------------
function InitWeatherGfxSets()
	SetupHighlandWeatherGfxSet()
    end
------------------------------------------------------------------------------
function InitWeather()
	AddPeriodicSummer(10)
end
------------------------------------------------------------------------------
function InitPlayerColorMapping()

    Display.SetPlayerColorMapping(1,PLAYER_COLOR)
    Display.SetPlayerColorMapping(3,PLAYER_COLOR)
    Display.SetPlayerColorMapping(2,EVIL_GOVERNOR_COLOR)
    Display.SetPlayerColorMapping(4,NPC_COLOR)
    Display.SetPlayerColorMapping(5,ENEMY_COLOR1)
    Display.SetPlayerColorMapping(6,FRIENDLY_COLOR1)
	Display.SetPlayerColorMapping(7,EVIL_GOVERNOR_COLOR)

end
------------------------------------------------------------------------------
function FirstMapAction()
	TriggerFix.AllScriptsLoaded()

    StartSimpleJob("heroesNearErec")
	
	Mission_OnSaveGameLoaded_Reloadfunc = Mission_OnSaveGameLoaded
	Mission_OnSaveGameLoaded = function()
	Mission_OnSaveGameLoaded_Reloadfunc()
	if BombArmy.SpawnerCountDown ~= nil then
			MapLocal_StartCountDown(BombArmy.SpawnerCountDown)
	end
	end
	
	TradeBlancerInit()
	
	local enginepos1 = GetPosition("steamenginetroop1")
	local enginepos2 = GetPosition("steamenginetroop2")
	AI.Entity_CreateFormation(2, Entities.PU_LeaderRifle2, nil, 8, enginepos1.X,enginepos1.Y, nil, nil, 3,0)
	AI.Entity_CreateFormation(2, Entities.PU_LeaderRifle2, nil, 8, enginepos2.X,enginepos2.Y, nil, nil, 3,0)

	-- String
	String.Init("CM02_02_BigRiver")

	Score.Player[0] = {buildings=0, all=0}
	EntityIdChangedHelper.Init()

	math.randomseed(XGUIEng.GetSystemTime())
	
    createPlayer2()
    createPlayer6()

    createQuestDefeat()

    beginChapterOne()

	LocalMusic.UseSet = HIGHLANDMUSIC
	
	ActivateTowerLimit(5)

	end


------------------------------------------------------------------------------
function SpecialManualGoldChest()
	
	if SpecialManualGoldChestFound == false then
		local Position = {}
		Position = GetPosition("SpecialManualGoldChest")	
		Camera.ScrollGameTimeSynced	(Position.X, Position.Y)
		CreateRandomGoldChest(Position)
		Logic.CreateEffect(GGL_Effects.FXYukiFireworksJoy, Position.X, Position.Y, 1)
		Sound.PlayGUISound(Sounds.Military_SO_Fireworks)
		Sound.PlayGUISound(Sounds.OnKlick_Select_mary_de_mortfichet)
		SpecialManualGoldChestFound = true
	end
	
	end